<div class="panel">
    <div class="panel-heading">
        {l s='Configurazione' mod='freeinvoice'}
    </div>
    {if $webhook_callback_url}
        <div class="alert alert-info">
            <strong>{l s='URL per configurazione Webhook FreeInvoice' mod='freeinvoice'}:</strong><br>
            <code id="webhook-url">{$webhook_callback_url}</code>
        </div>
    {/if}
    <form action="{$action_url}" method="post">
        <input type="hidden" name="token" value="{$token}" />
        <div class="row">
            <!-- Selettore piattaforma -->
            <div class="col-md-6" style="margin-top: 20px;">
                <label for="FREEINVOICE_SELECTED_PLATFORM">
                    {l s='Piattaforma' mod='freeinvoice'} <span class="required">*</span>
                </label>
                <select name="FREEINVOICE_SELECTED_PLATFORM" id="FREEINVOICE_SELECTED_PLATFORM" class="form-control">
                    <option value="freeinvoice" {if $fields_value.FREEINVOICE_SELECTED_PLATFORM == 'freeinvoice'}selected{/if}>
                        FreeInvoice
                    </option>
                    <option value="bpilot" {if $fields_value.FREEINVOICE_SELECTED_PLATFORM == 'bpilot'}selected{/if}>
                        BPilot
                    </option>
                    <option value="sandbox" {if $fields_value.FREEINVOICE_SELECTED_PLATFORM == 'sandbox'}selected{/if}>
                        Sandbox
                    </option>
                    <option value="custom" {if $fields_value.FREEINVOICE_SELECTED_PLATFORM == 'custom'}selected{/if}>
                        Personalizzato
                    </option>
                </select>
            </div>

            <!-- Campo per endpoint personalizzato -->
            <div class="col-md-12 custom-endpoint-fields" style="margin-top: 20px; display: none;">
                <label for="FREEINVOICE_CUSTOM_API_URL">
                    {l s='Endpoint API personalizzato' mod='freeinvoice'}
                </label>
                <input type="text" name="FREEINVOICE_CUSTOM_API_URL" id="FREEINVOICE_CUSTOM_API_URL" class="form-control"
                    value="{$fields_value.FREEINVOICE_CUSTOM_API_URL}" placeholder="https://sandbox.cloudfinance.it/api" />
            </div>
        </div>
        <div class="row">
            <!-- API Key -->
            <div class="col-md-12 " style="margin-top: 20px;">
                <label for="FREEINVOICE_CEDENTE_API_KEY">
                    {l s='API Key' mod='freeinvoice'} <span class="required">*</span>
                </label>
                <textarea name="FREEINVOICE_CEDENTE_API_KEY" id="FREEINVOICE_CEDENTE_API_KEY" class="form-control" rows="3" required>{$fields_value.FREEINVOICE_CEDENTE_API_KEY}</textarea>
            </div>
            <!-- Sincronizzazione -->
            <div class="col-md-6 " style="margin-top: 20px;">
                <label for="FREEINVOICE_CEDENTE_SYNC_TYPE">{l s='Sincronizzazione' mod='freeinvoice'}</label>
                <select name="FREEINVOICE_CEDENTE_SYNC_TYPE" id="FREEINVOICE_CEDENTE_SYNC_TYPE" class="form-control">
                    <option value="1" {if $fields_value.FREEINVOICE_CEDENTE_SYNC_TYPE == 1}selected{/if}>{l s='Attiva' mod='freeinvoice'}</option>
                    <option value="0" {if $fields_value.FREEINVOICE_CEDENTE_SYNC_TYPE == 0}selected{/if}>{l s='Disattiva' mod='freeinvoice'}</option>
                </select>
            </div>

            <!-- Regime Fiscale -->
           <div class="col-md-6 " style="margin-top: 20px;"> 
                <label for="FREEINVOICE_CEDENTE_TAX_REGIME">
                    {l s='Regime Fiscale' mod='freeinvoice'} <span class="required">*</span>
                </label>
                <select name="FREEINVOICE_CEDENTE_TAX_REGIME" id="FREEINVOICE_CEDENTE_TAX_REGIME" class="form-control"> {foreach from=$regimeFiscaleOptions item=option}
                        <option value="{$option.id}" {if $fields_value.FREEINVOICE_CEDENTE_TAX_REGIME == $option.id}selected{/if}>
                            {$option.name}
                        </option>
                    {/foreach}
                </select>
            </div>

            <!-- Email Cedente -->
            <div class="col-md-6 " style="margin-top: 20px;">
                <label for="FREEINVOICE_CEDENTE_EMAIL">
                    {l s='Email Cedente' mod='freeinvoice'} <span class="required">*</span>
                </label>
                <input type="email" name="FREEINVOICE_CEDENTE_EMAIL" id="FREEINVOICE_CEDENTE_EMAIL" class="form-control"
                       value="{$fields_value.FREEINVOICE_CEDENTE_EMAIL}" required />
            </div>

            <!-- Partita IVA e Codice Fiscale -->
            <div class="col-md-6 " style="margin-top: 20px;">
                <label for="FREEINVOICE_CEDENTE_ID">
                    {l s='Partita IVA Cedente' mod='freeinvoice'} <span class="required">*</span>
                </label>
                <input type="text" name="FREEINVOICE_CEDENTE_ID" id="FREEINVOICE_CEDENTE_ID" class="form-control"
                       value="{$fields_value.FREEINVOICE_CEDENTE_ID}" required />
            </div>
            
            <div class="col-md-6 " style="margin-top: 20px;">
                <label for="FREEINVOICE_CEDENTE_CODICE_FISCALE">
                    {l s='Codice Fiscale Cedente' mod='freeinvoice'} <span class="required">*</span>
                </label>
                <input type="text" name="FREEINVOICE_CEDENTE_CODICE_FISCALE" id="FREEINVOICE_CEDENTE_CODICE_FISCALE" class="form-control"
                       value="{$fields_value.FREEINVOICE_CEDENTE_CODICE_FISCALE}" required />
            </div>

            <!-- Denominazione Cedente -->
            <div class="col-md-6 " style="margin-top: 20px;">
                <label for="FREEINVOICE_CEDENTE_DENOMINAZIONE">
                    {l s='Denominazione Cedente' mod='freeinvoice'} <span class="required">*</span>
                </label>
                <input type="text" name="FREEINVOICE_CEDENTE_DENOMINAZIONE" id="FREEINVOICE_CEDENTE_DENOMINAZIONE" class="form-control"
                       value="{$fields_value.FREEINVOICE_CEDENTE_DENOMINAZIONE}" required />
            </div>

            <!-- Denominazione Rappresentante Fiscale -->
            <div class="col-md-6 " style="margin-top: 20px;">
                <label for="FREEINVOICE_CEDENTE_RIFERIMENTO_AMMINISTRAZIONE">
                    {l s='Riferimento Amministrazione' mod='freeinvoice'}
                </label>
                <input type="text" name="FREEINVOICE_CEDENTE_RIFERIMENTO_AMMINISTRAZIONE" id="FREEINVOICE_CEDENTE_RIFERIMENTO_AMMINISTRAZIONE" class="form-control"
                       value="{$fields_value.FREEINVOICE_CEDENTE_RIFERIMENTO_AMMINISTRAZIONE}"/>
            </div>

            <!-- Indirizzo Cedente -->
            <div class="col-md-6 " style="margin-top: 20px;">
                <label for="FREEINVOICE_CEDENTE_INDIRIZZO">
                    {l s='Indirizzo Cedente' mod='freeinvoice'} <span class="required">*</span>
                </label>
                <input type="text" name="FREEINVOICE_CEDENTE_INDIRIZZO" id="FREEINVOICE_CEDENTE_INDIRIZZO" class="form-control"
                       value="{$fields_value.FREEINVOICE_CEDENTE_INDIRIZZO}" required />
            </div>
            
            <!-- Numero Civico -->
            <div class="col-md-6 " style="margin-top: 20px;">
                <label for="FREEINVOICE_CEDENTE_CIVICO">
                    {l s='Numero Civico' mod='freeinvoice'} <span class="required">*</span>
                </label>
                <input type="text" name="FREEINVOICE_CEDENTE_CIVICO" id="FREEINVOICE_CEDENTE_CIVICO" class="form-control"
                       value="{$fields_value.FREEINVOICE_CEDENTE_CIVICO}" required />
            </div>

            <!-- CAP -->
            <div class="col-md-6 " style="margin-top: 20px;">
                <label for="FREEINVOICE_CEDENTE_CAP">
                    {l s='Numero CAP' mod='freeinvoice'} <span class="required">*</span>
                </label>
                <input type="text" name="FREEINVOICE_CEDENTE_CAP" id="FREEINVOICE_CEDENTE_CAP" class="form-control"
                       value="{$fields_value.FREEINVOICE_CEDENTE_CAP}" required />
            </div>

            <!-- Comune -->
            <div class="col-md-6 " style="margin-top: 20px;">
                <label for="FREEINVOICE_CEDENTE_COMUNE">
                    {l s='Comune' mod='freeinvoice'} <span class="required">*</span>
                </label>
                <input type="text" name="FREEINVOICE_CEDENTE_COMUNE" id="FREEINVOICE_CEDENTE_COMUNE" class="form-control"
                       value="{$fields_value.FREEINVOICE_CEDENTE_COMUNE}" required />
            </div>
            <!-- Nazione e Provincia -->
            <div class="col-md-6 " style="margin-top: 20px;">
                <label for="FREEINVOICE_CEDENTE_NAZIONE">
                    {l s='Nazione' mod='freeinvoice'} <span class="required">*</span>
                </label>
                <select name="FREEINVOICE_CEDENTE_NAZIONE" id="FREEINVOICE_CEDENTE_NAZIONE" class="form-control js-country">
                    {foreach from=$country_options item=country}
                        <option value="{$country.iso_code}" {if $fields_value.FREEINVOICE_CEDENTE_NAZIONE == $country.iso_code || $country.iso_code == 'IT'}selected{/if}>
                            {$country.name}
                        </option>
                    {/foreach}
                </select>
            </div>

            <div class="col-md-6 " style="margin-top: 20px;">
                <label for="FREEINVOICE_CEDENTE_PROVINCIA">
                    {l s='Provincia' mod='freeinvoice'} <span class="required">*</span>
                </label>
                <select name="FREEINVOICE_CEDENTE_PROVINCIA" id="FREEINVOICE_CEDENTE_PROVINCIA" class="form-control js-state">
                    {foreach from=$state_options item=state}
                        <option value="{$state.iso_code}" {if $fields_value.FREEINVOICE_CEDENTE_PROVINCIA == $state.iso_code}selected{/if}>
                            {$state.name}
                        </option>
                    {/foreach}
                </select>
            </div>
        </div>

        <button type="submit" name="submitFreeInvoiceConfig" class="btn mt-3 btn-primary" style="margin-top: 20px;">
            {l s='Salva' mod='freeinvoice'}
        </button>
    </form>
</div>

<style>
    .required {
        color: red;
        font-weight: bold;
    }
</style>

<script>
document.addEventListener("DOMContentLoaded", function () {
    let countrySelect = document.getElementById("FREEINVOICE_CEDENTE_NAZIONE");
    let stateSelect = document.getElementById("FREEINVOICE_CEDENTE_PROVINCIA");

    countrySelect.addEventListener("change", function () {
        let countryIso = this.value;

        fetch("{$ajax_url}&ajax=1&action=GetStatesByCountry&country_iso=" + countryIso)
            .then(response => response.json())
            .then(states => {
                stateSelect.innerHTML = "";
                states.forEach(state => {
                    let option = document.createElement("option");
                    option.value = state.id;
                    option.text = state.name;
                    stateSelect.appendChild(option);
                });
            })
            .catch(error => console.error("Errore nel caricamento delle province:", error));
    });
    function toggleCustomFields() {
        const selected = document.getElementById("FREEINVOICE_SELECTED_PLATFORM").value;
        const customFields = document.querySelectorAll(".custom-endpoint-fields");
        customFields.forEach(el => {
            el.style.display = (selected === "custom") ? "block" : "none";
        });
    }

    const platformSelector = document.getElementById("FREEINVOICE_SELECTED_PLATFORM");
    platformSelector.addEventListener("change", toggleCustomFields);

    toggleCustomFields();
});
</script>
