<?php
if (!defined('_PS_VERSION_')) {
    exit;
}

class FreeInvoiceWebhookReceiverModuleFrontController extends ModuleFrontController
{
    //public $ssl = true; // Forza HTTPS per maggiore sicurezza (imposta true se necessario)


    private function sendResponse($status = 'success', $message = '', $code = 200)
    {
        http_response_code($code);
        header('Content-Type: application/json');
        echo json_encode(
            [
                'status' => $status,
                'message' => $message
            ]);
        exit;
    }
    public function postProcess()
    {

        $requestUri = $_SERVER['REQUEST_URI'];
        // Recupera tutti gli header della richiesta
        $headers = getallheaders();
        $payloadString = file_get_contents('php://input');

        // Recupera altre informazioni sulla richiesta
        $requestMethod = $_SERVER['REQUEST_METHOD'] ?? 'UNKNOWN';
        $requestUri = $_SERVER['REQUEST_URI'] ?? 'UNKNOWN';
        $clientIp = $_SERVER['REMOTE_ADDR'] ?? 'UNKNOWN';

        // Formatta il log per renderlo leggibile
        $logMessage = "🚀 Webhook ricevuto!\n";
        $logMessage .= "🔹 Metodo: {$requestMethod}\n";
        $logMessage .= "🔹 URI: {$requestUri}\n";
        $logMessage .= "🔹 IP Cliente: {$clientIp}\n";
        $logMessage .= "🔹 Headers: " . json_encode($headers, JSON_PRETTY_PRINT) . "\n";
        $logMessage .= "🔹 Payload: " . ($payloadString ? json_encode(json_decode($payloadString, true), JSON_PRETTY_PRINT) : "Nessun Payload") . "\n";


        $apiKey = Configuration::get('FREEINVOICE_CEDENTE_API_KEY');
        if(!$apiKey || empty($apiKey)){
            $this->sendResponse('error', 'Api Key non configurata', 403);
            PrestaShopLogger::addLog("Api Key non configurata", 1);
            die(json_encode(['error' => 'Api Key non configurata']));
        }
        //
        // Validazione del payload
        $headers = getallheaders();
        $signature = $headers['X-Freeinvoice-Signature'] ?? null;
        $timestamp = $headers['X-Freeinvoice-Timestamp'] ?? null;
        // Genera la signature attesa
        if (!$signature || !$timestamp){
            PrestaShopLogger::addLog("invalid signature", 1);
            $this->sendResponse('success');
            die(json_encode(['error' => 'Invalid signature / timestamp']));
        }
        PrestaShopLogger::addLog("continua", 1);
         $expectedSignature = hash_hmac(
            'sha256',
            "{$timestamp}.{$payloadString}",
            $apiKey
        );

        // Confronta le signature
        if (!hash_equals($expectedSignature, $signature)) {
            PrestaShopLogger::addLog("hashequals error expected:" . $expectedSignature . " signature: ". $signature . "api: " . $apiKey , 1);
            http_response_code(403);
            die(json_encode(['error' => 'Invalid signature']));
        }
        
        $payload = json_decode(file_get_contents('php://input'), true);
        
        if(!$payloadString){
            die(json_encode(['error' => 'Invalid Payload']));
        }
        if (!$payload ) {
            PrestaShopLogger::addLog("not payload", 1);
            http_response_code(400);
            die(json_encode(['error' => 'Invalid payload']));
        }
        

        if(isset($payload['type']) && $payload['type'] == "test") {
            $this->sendResponse();
        }
       
        // Esegui logica personalizzata (es. aggiornare lo stato dell'ordine)
        //Qui deve aggiornare lo stato della fattura.
        PrestaShopLogger::addLog("status changed", 1);
        if (isset($payload['type']) && $payload['type'] == "invoice_status_changed" &&
            isset($payload['data']) && is_array($payload['data']) &&
            isset($payload['data']['invoiceId'])) {

            $data = $payload['data'];
            $invoiceId = (int)$data['invoiceId'];
            $invoiceStatus = isset($data['invoiceStatus']) ? pSQL($data['invoiceStatus']) : '';
            $invoiceStatusName = isset($data['invoiceStatusName']) ? pSQL($data['invoiceStatusName']) : '';

            $db = Db::getInstance();
            $sql = 'SELECT * FROM `' . _DB_PREFIX_ . 'freeinvoice_logs` WHERE `invoice_id` = ' . $invoiceId;
            $existingLog = $db->getRow($sql);
            PrestaShopLogger::addLog("Invoice ID $existingLog updated successfully.", 1);
            if ($existingLog) {
                $updateSql = 'UPDATE `' . _DB_PREFIX_ . 'freeinvoice_logs` SET 
                                `status_id` = "' . pSQL($invoiceStatus) . '",
                                `status_name` = "' . pSQL($invoiceStatusName) . '",
                                `date_upd` = NOW()
                            WHERE `invoice_id` = ' . $invoiceId;
                $db->execute($updateSql);

            } 
            
        } 

        // Rispondi con successo
        
        die(json_encode(['success' => true, 'message' => "Webhook ricevuto: ID fattura {$payload['invoice_id']}, stato {$payload['status']}, signature {$signature}, timestamp {$timestamp}, EXPECTED {$expectedSignature}"]));
    }
}
