<?php
namespace FreeInvoice\Services;
use Media;
class NotificationService
{
    /**
     * Mostra una notifica di successo (sia Flash che Growl)
     */
    public static function success($message, $title = 'Freeinvoice ✅')
    {
        // Notifica Growl (passata a JavaScript)
        Media::addJsDef([
            'growl_success' => [
                'title' => $title,
                'message' => $message,
            ],
        ]);
    }

    /**
     * Mostra una notifica di errore (sia Flash che Growl)
     */
    public static function error($message, $title = 'Freeinvoice ❌')
    {
        // Notifica Growl (passata a JavaScript)
        Media::addJsDef([
            'growl_error' => [
                'title' => $title,
                'message' => $message,
            ],
        ]);
    }

    /**
     * Mostra una notifica di avviso (sia Flash che Growl)
     */
    public static function warning($message, $title = 'Freeinvoice ⚠️')
    {
        // Notifica Growl (passata a JavaScript)
        Media::addJsDef([
           'growl_warning' => [
            'title' => 'Freeinvoice',
            'message' => $message,
    ]
        ]);
    }
}
