<?php

class AdminAjaxStatesController extends ModuleAdminController
{
    public function __construct()
    {
        parent::__construct();
        $this->ajax = true; // Indica che il controller gestisce solo richieste AJAX
    }

    public function ajaxProcessGetStatesByCountry()
    {
        // Recupera l'ID del paese dalla richiesta
        $country = Tools::getValue('country_iso');

        if (!$country) {
            die(json_encode(['error' => 'ID paese non valido']));
        }
        $countryId = (int) Country::getByIso($country);
        // Recupera gli stati della nazione
        $states = State::getStatesByIdCountry($countryId);

        // Formatta la risposta JSON
        die(json_encode($states));
    }
    
}
